{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:28:02 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinProcs,
  WinTypes,
  {$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  Buttons,
  MMSystem,
  MMUtils,
  MMObj,
  MMDSPObj,
  MMPcmSup,
  MMEQ,
  MMEQDlg,
  MMFXGen,
  MMWavOut,
  MMConect,
  MMDesign,
  MMSlider,
  MMDIBCv,
  MMSpGram, MMHTimer, MMHook;
  
type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    Connector: TMMConnector;
    StopBtn: TBitBtn;
    StartBtn: TSpeedButton;
    btnEQ: TButton;
    WaveOut: TMMWaveOut;
    MMSpectrogram1: TMMSpectrogram;
    Generator: TMMGenerator;
    GroupBox1: TGroupBox;
    sl0: TMMSlider;
    sl2: TMMSlider;
    sl3: TMMSlider;
    sl4: TMMSlider;
    sl5: TMMSlider;
    sl6: TMMSlider;
    sl7: TMMSlider;
    sl8: TMMSlider;
    sl9: TMMSlider;
    sl10: TMMSlider;
    sl11: TMMSlider;
    sl12: TMMSlider;
    sl13: TMMSlider;
    sl14: TMMSlider;
    sl15: TMMSlider;
    sl16: TMMSlider;
    sl17: TMMSlider;
    sl18: TMMSlider;
    sl19: TMMSlider;
    sl1: TMMSlider;
    slAmp: TMMSlider;
    slFreq: TMMSlider;
    GroupBox2: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    Label2: TLabel;
    Label4: TLabel;
    Equalizer: TMMEqualizer;
    HiTimer: TMMHiTimer;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure MMWaveStop(Sender: TObject);
    procedure MMWaveStart(Sender: TObject);
    procedure btnEQClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sliderChange(Sender: TObject);
    procedure RadioButtonClick(Sender: TObject);
    procedure slFreqChange(Sender: TObject);
    procedure slAmpChange(Sender: TObject);
    procedure HiTimerTimer(Sender: TObject);
  private
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
const
   nBands = 20;
var
   i: integer;
   bandWidth,f1,f2,Gain: Float;

begin
   { a simple example how to setup the bands at runtime }

   bandWidth := (Generator.SampleRate div 2)/nBands;
   f1 := 0;         { left cutoff freq for the band   }
   f2 := bandWidth; { right cutoff freq for the band  }
   Gain := 0;       { initial gain in dB for the band }

   for i := 0 to nBands-1 do
   begin
      Equalizer.Filters.AddObject(TMMEQFilter.CreateEx(f1,f2,Gain));
      FindComponent('sl'+IntToStr(i)).Tag := i;
      f1 := f1+bandWidth;
      f2 := f2+bandWidth;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.StartBtnClick(Sender: TObject);
begin
   if not (wosPlay in WaveOut.State) then
      WaveOut.Start;

   StartBtn.Down := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.StopBtnClick(Sender: TObject);
begin
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.MMWaveStart(Sender: TObject);
begin
   HiTimer.Enabled := True;
   StopBtn.Enabled := True;
   StartBtn.Down := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.MMWaveStop(Sender: TObject);
begin
   HiTimer.Enabled := False;
   WaveOut.Close;
   StopBtn.Enabled := False;
   StartBtn.Down := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnEQClick(Sender: TObject);
begin
   Equalizer.Enabled := not Equalizer.Enabled;
   if Equalizer.Enabled then btnEQ.Caption := 'EQ On'
   else btnEQ.Caption := 'EQ Off';
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.sliderChange(Sender: TObject);
begin
   with (Sender as TMMSlider) do
   begin
      Equalizer.Filters[Tag].Gain := Position;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.RadioButtonClick(Sender: TObject);
begin
   if Sender = RadioButton1 then
      Generator.WaveForm := wfSine
   else if Sender = RadioButton2 then
      Generator.WaveForm := wfSquare
   else if Sender = RadioButton3 then
      Generator.WaveForm := wfTriangle
   else
      Generator.WaveForm := wfNoise;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.slFreqChange(Sender: TObject);
begin
   Generator.Frequency := slFreq.Position;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.slAmpChange(Sender: TObject);
begin
   Generator.Amplitude := slAmp.Position;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.HiTimerTimer(Sender: TObject);
begin
   { we use the manual trigger mode for a smooth display (set AutoTrigger to False) }
   Connector.Trigger;
end;

end.
